<?php

namespace App\Model;

require_once "Database/MensagensDatabase.php";
require_once "Entity/Mensagens.php";

use stdClass;

use App\Database\MensagensDatabase;
use App\Entity\Mensagens;

class MensagensModel
{
    private $fileName;
    private $listMensagens = [];
    private $mensagensDatabase;
    
    // Constantes de Configuracao do Disparo de Mensagens
    const API_TOKEN = "64ac81dd454ba0735d2884ab";
    const VERIFY_CONTACT = true;

    public function __construct()
    {
        date_default_timezone_set('America/Sao_Paulo');
        $this->mensagensDatabase = new MensagensDatabase();
    }

    public function readAll()
    {
        $this->load();
        $contador = 0;

        for ($i = 0; $i < count($this->listMensagens); $i++) {
            $bolAtualizar = false;
            $dataProgramada = $this->listMensagens[$i]->getEnvProgramada();
            $dataAtual = date("Y-m-d H:i:s");
    
            if ($this->listMensagens[$i]->getEnvEnviada() != "SIM") {
                if ($dataProgramada == "") {
                    $bolAtualizar = true;
                } else {
                    $datetime1 = new \DateTime($dataProgramada);
                    $datetime2 = new \DateTime($dataAtual);
    
                    if ($datetime1 <= $datetime2) {
                        $bolAtualizar = true;
                    }
                }
            }
    
            if ($bolAtualizar) {
                $contador++;
                $arrRetorno = $this->enviaMensagem($this->listMensagens[$i]); 

                $status = "ERRO";

                if ($arrRetorno["result"]["status"] == "202") {
                    $status = "SUCESSO";
                }

                $this->update($this->listMensagens[$i],$dataAtual, $status);
                sleep(10);
            }                
        }
    }

    private function enviaMensagem(Mensagens $mensagens) 
    {
        if ($mensagens->getEnvTipo() == "Texto") {
            return $this->enviaMensagemTexto($mensagens);
        }
        else {
            return $this->enviaMensagemMidia($mensagens);
        }
    }

    private function enviaMensagemTexto(Mensagens $mensagens)
    {
        $data = array();

        $data['number']         = $mensagens->getEnvNumero();
        $data['message']        = $mensagens->getEnvTexto();
        $data['isWhisper']      = false;
        $data['forceSend']      = true;
        $data['verifyContact']  = self::VERIFY_CONTACT;
        
        return $this->callAPI('POST', 'https://api.chat-x.tec.br/core/v2/api/chats/send-text', json_encode($data));
    }

    private function enviaMensagemMidia(Mensagens $mensagens)
    {
        $data = array();

        $data['number']         = $mensagens->getEnvNumero();
        $data['caption']        = $mensagens->getEnvTexto();
        $data['extension']      = $mensagens->getEnvExtensao();
        $data['base64']         = $mensagens->getEnvMidia();
        $data['forceSend']      = true;
        $data['verifyContact']  = self::VERIFY_CONTACT;
        
        return $this->callAPI('POST', 'https://api.chat-x.tec.br/core/v2/api/chats/send-media', json_encode($data));
    }

    private function callAPI($method, $url, $data) 
    {
        $curl = curl_init();
        switch ($method) {
            case "POST":
                curl_setopt($curl, CURLOPT_POST, 1);
                if ($data)
                    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                break;
            case "PUT":
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
                if ($data)
                    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
                break;
            default:
                if ($data)
                    $url = sprintf("%s?%s", $url, http_build_query($data));
        }
        // OPTIONS:
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array(
            'access-token:' . self::API_TOKEN,
            'Content-Type: application/json',
        )
        );
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        // EXECUTE:
        $result = curl_exec($curl);
        $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        if (!$result) {
            die("Connection Failure");
        }
        curl_close($curl);

        return ['result' => json_decode($result, true), 'statusCode' => $httpcode];
    }

    private function convertValue($value)
    {
        $to_encoding = "UTF-8";
        $detect_order = "ISO-8859-1,UTF-8,ASCII";
        $from_encoding = mb_detect_encoding($value, $detect_order);
        $value = mb_convert_encoding($value, $to_encoding, $from_encoding);

        return $value;
    }

    private function load()
    {
        if (!$this->mensagensDatabase->getConn()) {
            return [];
        }

        $arrayMensagens = $this->mensagensDatabase->load();

        foreach ($arrayMensagens as $s) {
            $this->listMensagens[] =
                new Mensagens(
                    $this->convertValue($s->envCodigo),
                    $this->convertValue($s->envTexto),
                    $this->convertValue($s->envNumero),
                    $this->convertValue($s->envTipo),
                    $this->convertValue($s->envMidia),
                    $this->convertValue($s->envProgramada),
                    $this->convertValue($s->envEnviada),
                    $this->convertValue($s->envDataEnvio),
                    $this->convertValue($s->envStatus),
                    $this->convertValue($s->envExtensao)
                );
        }
    }

    public function update($mensagens, $dataAtual, $status)
    {
        $mensagens->setEnvDataEnvio($dataAtual);
        $mensagens->setEnvEnviada("SIM");
        $mensagens->setEnvStatus($status);

        $this->mensagensDatabase->update($mensagens);
    }
}