<?php
    namespace App\Database;

    use Mysqli;
    use stdClass;
    use App\Entity\Mensagens;
    use App\Util\Util;

    require_once "Entity/Mensagens.php";

    class MensagensDatabase {
        private $conn;
        
        public function __construct() {
            if (isset($_SERVER["SERVER_NAME"]) && $_SERVER["SERVER_NAME"] == "localhost") {
                $this->conn = new mysqli('localhost', 'root', '', 'chatxtec_extensao');
            }
            else {
                $this->conn = new mysqli('localhost', 'chatxtec_usuario', '$f^L7,QvX@?f', 'chatxtec_extensao');
            }        
        
            if ($this->conn->connect_error) {
                $this->conn = FALSE;
            }
        }

        public function getConn() {
            return $this->conn;
        }
        
        public function load() {
            $sql = "SELECT env_codigo, env_texto, env_numero, env_tipo, env_midia,
                        env_programada, env_enviada, env_dataenvio, env_status, env_extensao
                    FROM envio
                    ORDER BY env_codigo";

            $result = $this->conn->query($sql);

            if ($result->num_rows > 0) {
                $cursor = array();

                while($row = $result->fetch_assoc()) {
                    $obj = new stdClass();

                    $obj->envCodigo        = $row['env_codigo'];
                    $obj->envTexto         = $row['env_texto'];
                    $obj->envNumero        = $row['env_numero'];
                    $obj->envTipo          = $row['env_tipo'];
                    $obj->envMidia         = $row['env_midia'];
                    $obj->envProgramada    = $row['env_programada'];
                    $obj->envEnviada       = $row['env_enviada'];
                    $obj->envDataEnvio     = $row['env_dataenvio'];
                    $obj->envStatus        = $row['env_status'];
                    $obj->envExtensao      = $row['env_extensao'];

                    $cursor[] = $obj;
                }

                return $cursor;
            } else {
                return FALSE;
            }
        }

        public function update(Mensagens $mensagens) {
            $stmt = $this->conn->prepare("UPDATE envio 
                                          SET env_enviada=?, env_dataenvio=?, env_status=?
                                          WHERE env_codigo=?");

            $stmt->bind_param("sssi", $env_enviada, $env_dataenvio, $env_status, $env_codigo);

            $env_enviada       = $mensagens->getEnvEnviada();
            $env_dataenvio     = $mensagens->getEnvDataenvio();
            $env_status        = $mensagens->getEnvStatus();

            $env_codigo        = $mensagens->getEnvCodigo();
            
            $stmt->execute();            
        }
    }